<div>
    <?php
        $modalType = $this->modalType ?? 'default';
    ?>

    <!-- Add Modal -->
    <div class="modal fade" id="<?php echo e($modalType); ?>AddModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add New <?php echo e(ucfirst($modalType)); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" wire:click="resetAll"></button>
                </div>

                <form wire:submit.prevent="store" enctype="multipart/form-data">
                    <div class="modal-body">
                        <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo e(session('message')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- Title -->
                        <div class="mb-3">
                            <label class="form-label">Title *</label>
                            <input type="text" class="form-control" wire:model="title">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Custom Fields -->
                        
                            <!-- In the Add Modal and Edit Modal, update the custom fields section: -->

                        <!--[if BLOCK]><![endif]--><?php if($modalType === 'blog'): ?>
                            <!-- Blog fields (existing code) -->
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Category *</label>
                                    <select class="form-control" wire:model="customFields.category">
                                        <option value="">Select Category</option>
                                        <option value="Technology">Technology</option>
                                        <option value="Business">Business</option>
                                        <option value="Lifestyle">Lifestyle</option>
                                    </select>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Reading Time (minutes)</label>
                                    <input type="number" class="form-control" wire:model="customFields.reading_time" min="1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.reading_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Tags</label>
                                <input type="text" class="form-control" wire:model="customFields.tags" placeholder="tag1, tag2, tag3">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" wire:model="customFields.featured">
                                    <label class="form-check-label">Featured Post</label>
                                </div>
                            </div>

                        <?php elseif($modalType === 'publication'): ?>
                            <!-- Publication-specific fields -->
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Publication Category *</label>
                                    <select class="form-control" wire:model="customFields.publication_category" required>
                                        <option value="">Select Category</option>
                                        <option value="Research Paper">Research Paper</option>
                                        <option value="Journal Article">Journal Article</option>
                                        <option value="Conference Paper">Conference Paper</option>
                                        <option value="Book">Book</option>
                                        <option value="Thesis">Thesis</option>
                                        <option value="Technical Report">Technical Report</option>
                                    </select>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.publication_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">ISBN</label>
                                    <input type="text" class="form-control" wire:model="customFields.isbn" placeholder="Enter ISBN number">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.isbn'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Published Date</label>
                                    <input type="date" class="form-control" wire:model="customFields.published_date">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.published_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Publisher</label>
                                    <input type="text" class="form-control" wire:model="customFields.publisher" placeholder="Enter publisher name">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.publisher'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <!-- Status -->
                        <div class="mb-3">
                            <label class="form-label">Status *</label>
                            <select class="form-control" wire:model="status">
                                <option value="draft">Draft</option>
                                <option value="published">Published</option>
                                <option value="archived">Archived</option>
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Description -->
                        <div class="mb-3" wire:ignore>
                            <label class="form-label">Description *</label>
                            <textarea id="<?php echo e($modalType); ?>CreateEditor"><?php echo e($description ?? ''); ?></textarea>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Image -->
                        <div class="mb-3">
                            <label class="form-label">Image</label>
                            <input type="file" class="form-control" wire:model="image">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            <!--[if BLOCK]><![endif]--><?php if($image): ?>
                                <div class="mt-2">
                                    <img src="<?php echo e($image->temporaryUrl()); ?>" class="img-fluid rounded" style="max-height: 200px;">
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="resetAll">Close</button>
                        <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                            <span wire:loading.remove>Save</span>
                            <span wire:loading>Saving...</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Edit Modal -->
    <div class="modal fade" id="<?php echo e($modalType); ?>EditModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered modal-xl">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Edit <?php echo e(ucfirst($modalType)); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" wire:click="resetAll"></button>
                </div>

                <form wire:submit.prevent="update" enctype="multipart/form-data">
                    <div class="modal-body">
                        <!--[if BLOCK]><![endif]--><?php if(session()->has('message')): ?>
                            <div class="alert alert-success alert-dismissible fade show" role="alert">
                                <?php echo e(session('message')); ?>

                                <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <input type="hidden" wire:model="recordId">

                        <!-- Title -->
                        <div class="mb-3">
                            <label class="form-label">Title *</label>
                            <input type="text" class="form-control" wire:model="title">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Custom Fields -->
                        <!-- In the Add Modal and Edit Modal, update the custom fields section: -->

                        <!--[if BLOCK]><![endif]--><?php if($modalType === 'blog'): ?>
                            <!-- Blog fields (existing code) -->
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Category *</label>
                                    <select class="form-control" wire:model="customFields.category">
                                        <option value="">Select Category</option>
                                        <option value="Technology">Technology</option>
                                        <option value="Business">Business</option>
                                        <option value="Lifestyle">Lifestyle</option>
                                    </select>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Reading Time (minutes)</label>
                                    <input type="number" class="form-control" wire:model="customFields.reading_time" min="1">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.reading_time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Tags</label>
                                <input type="text" class="form-control" wire:model="customFields.tags" placeholder="tag1, tag2, tag3">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.tags'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            </div>

                            <div class="mb-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" wire:model="customFields.featured">
                                    <label class="form-check-label">Featured Post</label>
                                </div>
                            </div>

                        <?php elseif($modalType === 'publication'): ?>
                            <!-- Publication-specific fields -->
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Publication Category *</label>
                                    <select class="form-control" wire:model="customFields.publication_category" required>
                                        <option value="">Select Category</option>
                                        <option value="Research Paper">Research Paper</option>
                                        <option value="Journal Article">Journal Article</option>
                                        <option value="Conference Paper">Conference Paper</option>
                                        <option value="Book">Book</option>
                                        <option value="Thesis">Thesis</option>
                                        <option value="Technical Report">Technical Report</option>
                                    </select>
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.publication_category'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">ISBN</label>
                                    <input type="text" class="form-control" wire:model="customFields.isbn" placeholder="Enter ISBN number">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.isbn'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                            <div class="mb-3">
                                <label class="form-label">Authors *</label>
                                <input type="text" class="form-control" wire:model="customFields.authors" placeholder="Enter author names">
                                <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.authors'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                <div class="form-text">Separate multiple authors with commas</div>
                            </div>

                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label class="form-label">Published Date</label>
                                    <input type="date" class="form-control" wire:model="customFields.published_date">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.published_date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                                <div class="col-md-6">
                                    <label class="form-label">Publisher</label>
                                    <input type="text" class="form-control" wire:model="customFields.publisher" placeholder="Enter publisher name">
                                    <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['customFields.publisher'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                                </div>
                            </div>

                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->

                        <!-- Status -->
                        <div class="mb-3">
                            <label class="form-label">Status *</label>
                            <select class="form-control" wire:model="status">
                                <option value="draft">Draft</option>
                                <option value="published">Published</option>
                                <option value="archived">Archived</option>
                            </select>
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['status'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Description -->
                       <div class="mb-3" wire:ignore>
                            <label class="form-label">Description *</label>
                             <textarea id="<?php echo e($modalType); ?>EditEditor" wire:model="description"><?php echo e($description); ?></textarea>
                          <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['description'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                        </div>

                        <!-- Image -->
                        <div class="mb-3">
                            <label class="form-label">Current Image</label>
                            <!--[if BLOCK]><![endif]--><?php if($currentImage): ?>
                                <div class="mb-2">
                                    <img src="<?php echo e(asset('storage/'.$currentImage)); ?>" class="img-fluid rounded" style="max-height: 200px;">
                                </div>
                            <?php else: ?>
                                <p class="text-muted">No image</p>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <label class="form-label">Change Image</label>
                            <input type="file" class="form-control" wire:model="image">
                            <!--[if BLOCK]><![endif]--><?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> <span class="text-danger small"><?php echo e($message); ?></span> <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <!--[if BLOCK]><![endif]--><?php if($image): ?>
                                <div class="mt-2">
                                    <img src="<?php echo e($image->temporaryUrl()); ?>" class="img-fluid rounded" style="max-height: 200px;">
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        </div>
                    </div>

                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal" wire:click="resetAll">Cancel</button>
                        <button type="submit" class="btn btn-primary" wire:loading.attr="disabled">
                            <span wire:loading.remove>Update</span>
                            <span wire:loading>Updating...</span>
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- View Modal -->
    <div class="modal fade" id="<?php echo e($modalType); ?>ViewModal" tabindex="-1" wire:ignore.self>
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">View <?php echo e(ucfirst($modalType)); ?></h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <!-- In the View Modal, update the content section: -->
                <div class="modal-body">
                    <!--[if BLOCK]><![endif]--><?php if(isset($viewData['title'])): ?>
                        <div class="mb-3">
                            <label class="fw-bold">Title</label>
                            <p><?php echo e($viewData['title']); ?></p>
                        </div>
                        
                        <div class="mb-3">
                            <label class="fw-bold">Status</label>
                            <p><?php echo e(ucfirst($viewData['status'])); ?></p>
                        </div>
                        
                        <!--[if BLOCK]><![endif]--><?php if($modalType === 'blog' && isset($viewData['category'])): ?>
                            <div class="mb-3">
                                <label class="fw-bold">Category</label>
                                <p><?php echo e($viewData['category']); ?></p>
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        
                        <!--[if BLOCK]><![endif]--><?php if($modalType === 'publication'): ?>
                            <!--[if BLOCK]><![endif]--><?php if(isset($viewData['publication_category'])): ?>
                                <div class="mb-3">
                                    <label class="fw-bold">Publication Category</label>
                                    <p><?php echo e($viewData['publication_category']); ?></p>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <!--[if BLOCK]><![endif]--><?php if(isset($viewData['authors'])): ?>
                                <div class="mb-3">
                                    <label class="fw-bold">Authors</label>
                                    <p><?php echo e($viewData['authors']); ?></p>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <!--[if BLOCK]><![endif]--><?php if(isset($viewData['isbn'])): ?>
                                <div class="mb-3">
                                    <label class="fw-bold">ISBN</label>
                                    <p><?php echo e($viewData['isbn']); ?></p>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <!--[if BLOCK]><![endif]--><?php if(isset($viewData['published_date'])): ?>
                                <div class="mb-3">
                                    <label class="fw-bold">Published Date</label>
                                    <p><?php echo e(\Carbon\Carbon::parse($viewData['published_date'])->format('M d, Y')); ?></p>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                            
                            <!--[if BLOCK]><![endif]--><?php if(isset($viewData['publisher'])): ?>
                                <div class="mb-3">
                                    <label class="fw-bold">Publisher</label>
                                    <p><?php echo e($viewData['publisher']); ?></p>
                                </div>
                            <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                        
                        <div class="mb-3">
                            <label class="fw-bold">Description</label>
                            <div class="border rounded p-3">
                                <?php echo $viewData['description']; ?>

                            </div>
                        </div>
                        
                        <!--[if BLOCK]><![endif]--><?php if($viewData['image']): ?>
                            <div class="mb-3">
                                <label class="fw-bold">Image</label>
                                <img src="<?php echo e(asset('storage/'.$viewData['image'])); ?>" class="img-fluid rounded">
                            </div>
                        <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                    <?php endif; ?><!--[if ENDBLOCK]><![endif]-->
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
// Simple and robust modal manager
class SimpleModalManager {
    constructor() {
        this.modalType = '<?php echo e($modalType); ?>';
        this.currentOpenModal = null;
        this.init();
    }

    init() {
        this.initializeModals();
        this.setupLivewireEvents();
        this.setupGlobalHandlers();
        this.ensureCleanStart();
    }

    ensureCleanStart() {
        // Clean up any leftover modal states on page load
        document.querySelectorAll('.modal').forEach(modal => {
            modal.classList.remove('show');
            modal.style.display = 'none';
        });
        
        // Remove any leftover backdrops
        document.querySelectorAll('.modal-backdrop').forEach(backdrop => {
            backdrop.remove();
        });
        
        // Reset body
        document.body.classList.remove('modal-open');
    }

    initializeModals() {
        console.log('🔄 Initializing modals for:', this.modalType);
        
        ['AddModal', 'EditModal', 'ViewModal'].forEach(suffix => {
            this.initializeSingleModal(this.modalType + suffix);
        });
    }

    initializeSingleModal(modalId) {
        const modalElement = document.getElementById(modalId);
        if (!modalElement) return;

        // Clean up existing instance
        const existingInstance = bootstrap.Modal.getInstance(modalElement);
        if (existingInstance) {
            existingInstance.dispose();
        }

        // Create fresh instance
        const modalInstance = new bootstrap.Modal(modalElement, {
            backdrop: true,
            keyboard: true,
            focus: true
        });

        // Store reference
        modalElement.bootstrapInstance = modalInstance;

        this.setupModalEvents(modalElement, modalId);
    }

    setupModalEvents(modalElement, modalId) {
        // Clone to remove old event listeners
        const newModal = modalElement.cloneNode(true);
        modalElement.parentNode.replaceChild(newModal, modalElement);
        
        const freshModal = document.getElementById(modalId);
        if (!freshModal) return;

        freshModal.addEventListener('show.bs.modal', () => {
            console.log('Opening modal:', modalId);
            this.closeAnyOpenModal(); // Close any other open modal first
            this.currentOpenModal = modalId;
        });

        freshModal.addEventListener('shown.bs.modal', () => {
            console.log('Modal shown:', modalId);
            if (modalId.includes('EditModal')) {
                this.initCKEditor(this.modalType + 'EditEditor', 'edit');
            } else if (modalId.includes('AddModal')) {
                this.initCKEditor(this.modalType + 'CreateEditor', 'create');
            }
        });

        freshModal.addEventListener('hide.bs.modal', () => {
            console.log('Closing modal:', modalId);
        });

        freshModal.addEventListener('hidden.bs.modal', () => {
            console.log('Modal hidden:', modalId);
            this.currentOpenModal = null;
            
            if (modalId.includes('EditModal')) {
                this.destroyCKEditor(this.modalType + 'EditEditor');
            } else if (modalId.includes('AddModal')) {
                this.destroyCKEditor(this.modalType + 'CreateEditor');
            }

            this.cleanupAfterClose();
        });
    }

    closeAnyOpenModal() {
        if (this.currentOpenModal) {
            const currentModal = document.getElementById(this.currentOpenModal);
            if (currentModal) {
                const instance = bootstrap.Modal.getInstance(currentModal);
                if (instance) {
                    instance.hide();
                }
            }
        }
    }

    cleanupAfterClose() {
        // Wait a bit then clean up
        setTimeout(() => {
            // Remove extra backdrops
            const backdrops = document.querySelectorAll('.modal-backdrop');
            if (backdrops.length > 1) {
                console.log('Removing extra backdrops');
                for (let i = 1; i < backdrops.length; i++) {
                    backdrops[i].remove();
                }
            }

            // Ensure body is clean
            const openModals = document.querySelectorAll('.modal.show');
            if (openModals.length === 0) {
                document.body.classList.remove('modal-open');
                document.body.style.paddingRight = '';
                document.body.style.overflow = '';
            }
        }, 150);
    }

    initCKEditor(editorId, mode) {
        // Destroy existing first
        this.destroyCKEditor(editorId);

        if (typeof ClassicEditor === 'undefined') {
            setTimeout(() => this.initCKEditor(editorId, mode), 100);
            return;
        }

        const editorElement = document.getElementById(editorId);
        if (!editorElement) return;

        ClassicEditor.create(editorElement)
            .then(editor => {
                window[editorId + '_instance'] = editor;
                
                if (mode === 'edit') {
                    const content = editorElement.value;
                    if (content) editor.setData(content);
                }

                editor.model.document.on('change:data', () => {
                    editorElement.value = editor.getData();
                });
            })
            .catch(console.error);
    }

    destroyCKEditor(editorId) {
        const editor = window[editorId + '_instance'];
        if (editor) {
            editor.destroy().catch(() => {});
            delete window[editorId + '_instance'];
        }
    }

    setupLivewireEvents() {
        if (typeof Livewire === 'undefined') {
            setTimeout(() => this.setupLivewireEvents(), 100);
            return;
        }

        Livewire.on('open-modal', (modalId) => {
            console.log('🚪 Livewire opening:', modalId);
            this.openModal(modalId);
        });

        Livewire.on('close-modal', (modalId) => {
            console.log('🚪 Livewire closing:', modalId);
            this.closeModal(modalId);
        });
    }

    setupGlobalHandlers() {
        // Handle manual modal clicks
        document.addEventListener('click', (e) => {
            const trigger = e.target.closest('[data-bs-toggle="modal"]');
            if (trigger && trigger.getAttribute('data-bs-toggle') === 'modal') {
                const targetModal = trigger.getAttribute('data-bs-target');
                if (targetModal?.startsWith('#')) {
                    e.preventDefault();
                    this.openModal(targetModal.substring(1));
                }
            }
        });

        // Handle page navigation
        if (typeof Livewire !== 'undefined') {
            document.addEventListener('livewire:navigating', () => {
                this.cleanupAll();
            });

            document.addEventListener('livewire:navigated', () => {
                setTimeout(() => new SimpleModalManager(), 500);
            });
        }
    }

    openModal(modalId) {
        this.closeAnyOpenModal(); // Close any open modal first
        
        const modalElement = document.getElementById(modalId);
        if (!modalElement) {
            console.error('Modal not found:', modalId);
            return;
        }

        let modalInstance = modalElement.bootstrapInstance;
        if (!modalInstance) {
            modalInstance = new bootstrap.Modal(modalElement);
            modalElement.bootstrapInstance = modalInstance;
        }

        modalInstance.show();
    }

    closeModal(modalId) {
        const modalElement = document.getElementById(modalId);
        if (!modalElement) return;

        const modalInstance = bootstrap.Modal.getInstance(modalElement);
        if (modalInstance) {
            modalInstance.hide();
        }
    }

    cleanupAll() {
        console.log('🧹 Cleaning up all modals');
        
        // Destroy CKEditors
        this.destroyCKEditor(this.modalType + 'EditEditor');
        this.destroyCKEditor(this.modalType + 'CreateEditor');
        
        // Close all modals
        document.querySelectorAll('.modal').forEach(modal => {
            const instance = bootstrap.Modal.getInstance(modal);
            if (instance) instance.hide();
        });
        
        this.cleanupAfterClose();
    }
}

// Initialize
document.addEventListener('DOMContentLoaded', () => {
    new SimpleModalManager();
});

// Debug
window.debugModals = function() {
    console.log('=== MODAL DEBUG ===');
    document.querySelectorAll('.modal').forEach(modal => {
        const instance = bootstrap.Modal.getInstance(modal);
        console.log(`${modal.id}:`, {
            instance: instance ? '✅' : '❌',
            visible: modal.classList.contains('show') ? '✅' : '❌',
            display: modal.style.display
        });
    });
    
    const backdrops = document.querySelectorAll('.modal-backdrop');
    console.log('Backdrops:', backdrops.length);
};
</script><?php /**PATH /Users/malando/Downloads/laravelApps/project-clear/resources/views/livewire/modals/base-modal-component.blade.php ENDPATH**/ ?>